---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-All Jobs（全ジョブ一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **タイムラインJavaScript描画関数の詳細仕様**：timeline-view.jsの実体未確認
  2. **デフォルトポート4040のアクセス方法**：SparkUI設定ファイルの直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` （AllJobsPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/JobsTab.scala` （JobsTabクラス全体）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.1の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.1の関連機能）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` （JobsTab内の遷移関係）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` （ApiHelper定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /jobs/ である | E-01 (40行目: WebUIPage("")) + E-02 (30行目: SparkUITab(parent, "jobs")) | ○ |
| C-02 | ルート(/)から/jobs/にリダイレクトされる | E-03 (備考欄: "SparkUIのデフォルト画面") | ○ |
| C-03 | ジョブはActive/Completed/Failedに3分類される | E-01 (284-297行目: activeJobs/completedJobs/failedJobs ListBuffer) | ○ |
| C-04 | store.jobsList(null)で全ジョブを取得する | E-01 (288行目: store.jobsList(null)) | ○ |
| C-05 | タイムラインは折りたたみ可能である | E-01 (200-206行目: expand-application-timeline, collapsed class) | ○ |
| C-06 | タイムラインはspark.ui.timeline.enabledで無効化可能 | E-01 (44行目: UI_TIMELINE_ENABLED, 178行目: if (!TIMELINE_ENABLED) return) | ○ |
| C-07 | タイムラインのジョブ最大数はUI_TIMELINE_JOBS_MAXIMUMで制御 | E-01 (45行目: MAX_TIMELINE_JOBS, 77行目: takeRight(MAX_TIMELINE_JOBS)) | ○ |
| C-08 | タイムラインのExecutor最大数はUI_TIMELINE_EXECUTORS_MAXIMUMで制御 | E-01 (46行目: MAX_TIMELINE_EXECUTORS, 131行目: takeRight(MAX_TIMELINE_EXECUTORS)) | ○ |
| C-09 | Kill操作にはkillEnabledとcheckModifyPermissions確認が必要 | E-02 (50-51行目: killEnabled && parent.securityManager.checkModifyPermissions) | ○ |
| C-10 | Kill操作は確認ダイアログを表示する | E-01 (576-578行目: window.confirm) | ○ |
| C-11 | Kill操作後に100ms待機する | E-02 (59行目: Thread.sleep(100)) | ○ |
| C-12 | サマリーにUser, Started At, Total Uptime, Scheduling Modeを表示 | E-01 (323-348行目: summary内のli要素) | ○ |
| C-13 | スケジューリングモードはenvironmentInfoから取得される | E-01 (318-321行目: store.environmentInfo().sparkProperties) | ○ |
| C-14 | テーブルカラムはJob Id, Description, Submitted, Duration, Stages, Tasks | E-01 (555-564行目: jobHeadersAndCssClasses) | ○ |
| C-15 | Job Id, Description, Submitted, Durationがソート可能 | E-01 (555-563行目: true/falseフラグ) | ○ |
| C-16 | Stages, Tasksはソート不可 | E-01 (562-563行目: false) | ○ |
| C-17 | タスク進捗バーが表示される | E-01 (611-614行目: UIUtils.makeProgressBar) | ○ |
| C-18 | ジョブIDリンクはJob Detail画面に遷移する | E-01 (471行目: basePath/jobs/job/?id=, 599行目: detailUrl) | ○ |
| C-19 | Completed Jobsの表示数が実際と異なる場合に注記が表示される | E-01 (311-315行目: numCompletedJobs != completedJobs.size時のフォーマット) | ○ |
| C-20 | ヘルプテキストが表示される | E-01 (420-421行目: helpText) | ○ |
| C-21 | ジョブグループが存在する場合カラム名が変わる | E-01 (251-252行目: someJobHasJobGroup判定) | ○ |
| C-22 | テーブルレンダリングエラー時にalert表示 | E-01 (268-275行目: catch IllegalArgumentException/IndexOutOfBoundsException) | ○ |
| C-23 | ジョブタイムラインにSucceeded=緑, Failed=赤, Running=青 | E-01 (48-59行目: JOBS_LEGEND SVG) | ○ |
| C-24 | Executorタイムラインに追加=Added, 削除=Removed | E-01 (61-69行目: EXECUTORS_LEGEND SVG) | ○ |
| C-25 | makeJobEventはsubmissionTime/completionTimeでソートしtakeRight | E-01 (73-77行目: sortBy/takeRight) | ○ |
| C-26 | SPARK-33991のenum変換エラー回避処理がある | E-01 (317行目: コメント) | ○ |
| C-27 | ページング・ソートはURLパラメータで制御される | E-01 (520-521行目: getTableParameters/getParameterOtherTable) | ○ |
| C-28 | cancelJobの引数は"killed via Web UI" | E-02 (55行目: "killed via Web UI") | ○ |
| C-29 | デフォルトポートは4040である | **根拠なし** | △ |
| C-30 | drawApplicationTimeline関数でタイムラインを描画する | E-01 (239行目: drawApplicationTimeline) だが関数実体の詳細は未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルトポート4040の根拠：SparkUI設定のデフォルト値定義ファイル（internal/config/UI.scala）の直接確認が不足
  - 候補：`core/src/main/scala/org/apache/spark/internal/config/UI.scala` / Sparkドキュメント
- timeline-view.jsの詳細仕様：JavaScript側の描画処理の実体が未確認
  - 候補：`core/src/main/resources/org/apache/spark/ui/static/timeline-view.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造・データフローは全てソースコードで確認済み
- 0: 低リスク - 関連機能マッピングはCSVファイルと完全一致
- 1: 中リスク - JavaScript側のタイムライン描画の詳細仕様は未確認（表示上の問題のみ）

## 6) レビュアーチェックリスト（最小）
- [ ] Kill操作の権限制御が正確に記載されているか確認
- [ ] テーブルカラムのソート可否が実装と一致しているか確認
- [ ] タイムライン設定パラメータのデフォルト値が正確か確認
- [ ] 画面遷移先（Job Detail）のURLパターンが正確か確認
